// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/public/common/mojo_geoposition.mojom
//

package org.chromium.mojom.content;

public final class MojoGeoposition extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 88;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(88, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public static final class ErrorCode {
    
        public static final int ERROR_CODE_NONE = (int) (0L);
        public static final int ERROR_CODE_PERMISSION_DENIED = (int) (1L);
        public static final int ERROR_CODE_POSITION_UNAVAILABLE = (int) (2L);
        public static final int ERROR_CODE_TIMEOUT = (int) (3L);
        public static final int ERROR_CODE_LAST = (int) (MojoGeoposition.ErrorCode.ERROR_CODE_TIMEOUT);
    
        private ErrorCode() {}
    
    }

    public boolean valid;
    public double latitude;
    public double longitude;
    public double altitude;
    public double accuracy;
    public double altitudeAccuracy;
    public double heading;
    public double speed;
    public double timestamp;
    public int errorCode;
    public String errorMessage;

    private MojoGeoposition(int version) {
        super(STRUCT_SIZE, version);
    }

    public MojoGeoposition() {
        this(0);
    }

    public static MojoGeoposition deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static MojoGeoposition decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        MojoGeoposition result = new MojoGeoposition(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.valid = decoder0.readBoolean(8, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.errorCode = decoder0.readInt(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.latitude = decoder0.readDouble(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.longitude = decoder0.readDouble(24);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.altitude = decoder0.readDouble(32);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.accuracy = decoder0.readDouble(40);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.altitudeAccuracy = decoder0.readDouble(48);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.heading = decoder0.readDouble(56);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.speed = decoder0.readDouble(64);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.timestamp = decoder0.readDouble(72);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.errorMessage = decoder0.readString(80, false);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(valid, 8, 0);
        encoder0.encode(errorCode, 12);
        encoder0.encode(latitude, 16);
        encoder0.encode(longitude, 24);
        encoder0.encode(altitude, 32);
        encoder0.encode(accuracy, 40);
        encoder0.encode(altitudeAccuracy, 48);
        encoder0.encode(heading, 56);
        encoder0.encode(speed, 64);
        encoder0.encode(timestamp, 72);
        encoder0.encode(errorMessage, 80, false);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        MojoGeoposition other = (MojoGeoposition) object;
        if (this.valid != other.valid)
            return false;
        if (this.latitude != other.latitude)
            return false;
        if (this.longitude != other.longitude)
            return false;
        if (this.altitude != other.altitude)
            return false;
        if (this.accuracy != other.accuracy)
            return false;
        if (this.altitudeAccuracy != other.altitudeAccuracy)
            return false;
        if (this.heading != other.heading)
            return false;
        if (this.speed != other.speed)
            return false;
        if (this.timestamp != other.timestamp)
            return false;
        if (this.errorCode != other.errorCode)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.errorMessage, other.errorMessage))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(valid);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(latitude);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(longitude);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(altitude);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(accuracy);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(altitudeAccuracy);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(heading);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(speed);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(timestamp);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(errorCode);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(errorMessage);
        return result;
    }
}

